/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.cycle;

import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.configurer.onetoone.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.runtime.SecondPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.cycle.AbstractCycleLoader;
import org.codefilarete.stalactite.engine.runtime.cycle.CycleLoadRuntimeContext;
import org.codefilarete.stalactite.engine.runtime.cycle.EntityRelationStorage;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;

public class OneToOneCycleLoader<SRC, TRGT, TRGTID>
extends AbstractCycleLoader<SRC, TRGT, TRGTID>
implements FirstPhaseCycleLoadListener<SRC, TRGTID> {
    public OneToOneCycleLoader(EntityPersister<TRGT, TRGTID> targetPersister) {
        super(targetPersister);
    }

    @Override
    public void onFirstPhaseRowRead(SRC src, TRGTID targetId) {
        if (!SecondPhaseRelationLoader.isDefaultValue(targetId)) {
            this.relations.forEach((relationName, configurationResult) -> {
                if (configurationResult.getSourcePersister().getClassToPersist().isInstance(src)) {
                    ((CycleLoadRuntimeContext)this.currentRuntimeContext.get()).addRelationToInitialize((String)relationName, src, targetId);
                }
            });
        }
    }

    @Override
    protected void applyRelationToSource(EntityRelationStorage<SRC, TRGTID> relationStorage, BeanRelationFixer<SRC, TRGT> beanRelationFixer, Map<TRGTID, TRGT> targetPerId) {
        relationStorage.getEntitiesToFulFill().forEach(src -> {
            Set trgtids = relationStorage.getRelationToInitialize(src);
            if (trgtids != null) {
                trgtids.forEach(targetId -> beanRelationFixer.apply(src, targetPerId.get(targetId)));
            }
        });
    }
}

